<?php
require 'config.php';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$pStmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
$pStmt->execute([$id]);
$p = $pStmt->fetch();
if(!$p) { die('Producto no encontrado'); }

$imgStmt = $pdo->prepare("SELECT filename FROM product_images WHERE product_id = ? ORDER BY id LIMIT 10");
$imgStmt->execute([$id]);
$images = $imgStmt->fetchAll();

$company = $pdo->query("SELECT * FROM company LIMIT 1")->fetch();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title><?php echo htmlspecialchars($p['title']); ?></title>
<link rel="stylesheet" href="assets/style.css"></head><body>
<div class="wrap">
  <a href="index.php">← Volver</a>
  <h1><?php echo htmlspecialchars($p['title']); ?></h1>
  <div class="product">
    <div class="gallery">
      <?php foreach($images as $img): ?>
        <img src="uploads/<?php echo htmlspecialchars($img['filename']); ?>" class="gallery-img">
      <?php endforeach; ?>
    </div>
    <div class="details">
      <p class="price"><?php echo htmlspecialchars($p['price']); ?></p>
      <p><?php echo nl2br(htmlspecialchars($p['description'])); ?></p>
      <?php if($p['external_link']): ?>
        <p><a class="btn" href="<?php echo htmlspecialchars($p['external_link']); ?>" target="_blank">Ir al enlace</a></p>
      <?php endif; ?>
    </div>
  </div>
</div>
</body></html>
