<?php
require 'config.php';
$catStmt = $pdo->query("SELECT * FROM categories ORDER BY name");
$categories = $catStmt->fetchAll();

$catFilter = isset($_GET['cat']) ? (int)$_GET['cat'] : 0;
if ($catFilter) {
    $stmt = $pdo->prepare("SELECT p.* FROM products p JOIN product_categories pc ON p.id = pc.product_id WHERE pc.category_id = ? ORDER BY p.id DESC");
    $stmt->execute([$catFilter]);
} else {
    $stmt = $pdo->query("SELECT * FROM products ORDER BY id DESC");
}
$products = $stmt->fetchAll();

$company = $pdo->query("SELECT * FROM company LIMIT 1")->fetch();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Tienda - <?php echo htmlspecialchars($company['name'] ?? 'Mi Tienda'); ?></title>
<link rel="stylesheet" href="assets/style.css">
</head>
<body>
<header>
  <div class="wrap">
    <img src="<?php echo htmlspecialchars($company['logo'] ?? ''); ?>" alt="Logo" class="logo" onerror="this.style.display='none'">
    <h1><?php echo htmlspecialchars($company['name'] ?? 'Mi Tienda'); ?></h1>
    <div class="contact">
      <div>Tel: <?php echo htmlspecialchars($company['phone'] ?? '-'); ?></div>
      <div>Email: <?php echo htmlspecialchars($company['email'] ?? '-'); ?></div>
    </div>
  </div>
</header>
<nav class="wrap">
  <div class="categories">
    <a href="index.php">Todas</a>
    <?php foreach($categories as $c): ?>
      <a href="index.php?cat=<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['name']); ?></a>
    <?php endforeach; ?>
  </div>
</nav>
<main class="wrap">
  <div class="grid">
  <?php foreach($products as $p): 
    $imgStmt = $pdo->prepare("SELECT filename FROM product_images WHERE product_id = ? ORDER BY id LIMIT 10");
    $imgStmt->execute([$p['id']]);
    $images = $imgStmt->fetchAll();
  ?>
    <div class="card">
      <?php if(count($images)): ?>
        <img src="uploads/<?php echo htmlspecialchars($images[0]['filename']); ?>" class="card-img">
      <?php else: ?>
        <div class="noimg">Sin imagen</div>
      <?php endif; ?>
      <h3><?php echo htmlspecialchars($p['title']); ?></h3>
      <p class="price"><?php echo htmlspecialchars($p['price']); ?></p>
      <p><?php echo nl2br(htmlspecialchars($p['short_desc'])); ?></p>
      <a class="btn" href="product.php?id=<?php echo $p['id']; ?>">Ver</a>
      <?php if($p['external_link']): ?>
        <a class="btn outline" href="<?php echo htmlspecialchars($p['external_link']); ?>" target="_blank">Enlace</a>
      <?php endif; ?>
    </div>
  <?php endforeach; ?>
  </div>
</main>
<footer class="wrap">
  <small>© <?php echo date('Y'); ?> <?php echo htmlspecialchars($company['name'] ?? 'Mi Tienda'); ?></small>
</footer>
</body>
</html>
