<?php
require '../config.php';
if(empty($_SESSION['admin'])){ header('Location: login.php'); exit; }

if(isset($_POST['title'])){
    $id = !empty($_POST['id']) ? (int)$_POST['id'] : 0;
    $title = $_POST['title'];
    $short = $_POST['short_desc'];
    $desc = $_POST['description'];
    $price = $_POST['price'];
    $external = $_POST['external_link'];
    if($id){
        $pdo->prepare('UPDATE products SET title=?, short_desc=?, description=?, price=?, external_link=? WHERE id=?')
            ->execute([$title,$short,$desc,$price,$external,$id]);
    } else {
        $pdo->prepare('INSERT INTO products (title, short_desc, description, price, external_link) VALUES (?,?,?,?,?)')
            ->execute([$title,$short,$desc,$price,$external]);
        $id = $pdo->lastInsertId();
    }
    $pdo->prepare('DELETE FROM product_categories WHERE product_id = ?')->execute([$id]);
    if(!empty($_POST['categories'])){
        foreach($_POST['categories'] as $c){
            $pdo->prepare('INSERT INTO product_categories (product_id, category_id) VALUES (?,?)')->execute([$id,(int)$c]);
        }
    }
    if(!empty($_FILES['images'])){
        for($i=0;$i<count($_FILES['images']['name']) && $i<10;$i++){
            if($_FILES['images']['error'][$i] === 0){
                $name = time()."_".basename($_FILES['images']['name'][$i]);
                move_uploaded_file($_FILES['images']['tmp_name'][$i],'../uploads/'.$name);
                $pdo->prepare('INSERT INTO product_images (product_id, filename) VALUES (?,?)')->execute([$id,$name]);
            }
        }
    }
    header('Location: products.php');
    exit;
}

if(isset($_GET['del'])){
    $id = (int)$_GET['del'];
    $imgrows = $pdo->query('SELECT filename FROM product_images WHERE product_id = '.(int)$id)->fetchAll();
    foreach($imgrows as $r){ @unlink('../uploads/'.$r['filename']); }
    $pdo->prepare('DELETE FROM product_images WHERE product_id = ?')->execute([$id]);
    $pdo->prepare('DELETE FROM product_categories WHERE product_id = ?')->execute([$id]);
    $pdo->prepare('DELETE FROM products WHERE id = ?')->execute([$id]);
    header('Location: products.php');
    exit;
}

$products = $pdo->query('SELECT * FROM products ORDER BY id DESC')->fetchAll();
$categories = $pdo->query('SELECT * FROM categories ORDER BY name')->fetchAll();

$edit = null;
if(isset($_GET['edit'])){
    $eid = (int)$_GET['edit'];
    $editStmt = $pdo->prepare('SELECT * FROM products WHERE id = ?');
    $editStmt->execute([$eid]);
    $edit = $editStmt->fetch();
    $selCats = $pdo->prepare('SELECT category_id FROM product_categories WHERE product_id = ?');
    $selCats->execute([$eid]);
    $selCats = array_column($selCats->fetchAll(),'category_id');
} else $selCats = [];
?>
<!doctype html><html><head><meta charset="utf-8"><title>Productos</title><link rel="stylesheet" href="../assets/style.css"></head><body>
<div class="wrap">
  <h2>Productos</h2>
  <a class="btn" href="?new=1">Agregar Producto</a>
  <?php if(isset($_GET['new']) || $edit): ?>
    <form method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?php echo $edit['id'] ?? ''; ?>">
      <label>Título</label><input name="title" required value="<?php echo $edit['title'] ?? ''; ?>">
      <label>Precio</label><input name="price" value="<?php echo $edit['price'] ?? ''; ?>">
      <label>Resumen</label><textarea name="short_desc"><?php echo $edit['short_desc'] ?? ''; ?></textarea>
      <label>Descripción</label><textarea name="description"><?php echo $edit['description'] ?? ''; ?>"></textarea>
      <label>Enlace externo (botón)</label><input name="external_link" value="<?php echo $edit['external_link'] ?? ''; ?>">
      <label>Categorías (ctrl/cmd click para múltiple)</label>
      <select name="categories[]" multiple size="5">
        <?php foreach($categories as $c): $sel = in_array($c['id'],$selCats) ? 'selected':''; ?>
          <option value="<?php echo $c['id']; ?>" <?php echo $sel; ?>><?php echo htmlspecialchars($c['name']); ?></option>
        <?php endforeach; ?>
      </select>
      <label>Imágenes (hasta 10)</label><input type="file" name="images[]" multiple accept="image/*">
      <button class="btn">Guardar</button>
    </form>
  <?php endif; ?>

  <ul class="list">
    <?php foreach($products as $p): ?>
      <li>
        <?php echo htmlspecialchars($p['title']); ?> - <?php echo htmlspecialchars($p['price']); ?>
        <a class="small" href="?edit=<?php echo $p['id']; ?>">Editar</a>
        <a class="small" href="?del=<?php echo $p['id']; ?>" onclick="return confirm('Eliminar?')">Eliminar</a>
      </li>
    <?php endforeach; ?>
  </ul>
  <p><a href="dashboard.php">← Volver</a></p>
</div>
</body></html>
